import scalevi.utils.utils as utils


def get_users_dir(nb):
    return  "../data/datasets/users_data/" if nb else "data/datasets/users_data/"

def get_users_fname():
    return "full_users_data.npz"

def get_leM_users_fname(M):
    return "leM_"+str(M)+"_users_data.npz"

def get_leM_train_test_fname(M, split):
    return f"train_test_leM_{M}_split_{split}_data.npz"

def get_genome_dir(nb):
    return  "../data/datasets/genome_data/" if nb else "data/datasets/genome_data/"

def get_genome_fname():
    return "full_genome_data.npz"

def get_PCAed_genome_fnames(dims):
    if utils.is_list_tuple_array(dims):
        fnames = ["dim_"+str(d)+"_genome_data.npz" for d in dims]
    else :
        fnames = "dim_"+str(dims)+"_genome_data.npz"
    return fnames
